package;

#if discord_rpc
import Discord.DiscordClient;
#end
#if USE_SHADERS
import shaders.ColorSwap;
#end
#if html5
import openfl.display.Sprite;
import openfl.net.NetStream;
import openfl.media.Video;
import openfl.Lib;
#end
import ui.PreferencesMenu;
import flixel.FlxG;
import flixel.FlxSprite;
import flixel.addons.transition.FlxTransitionSprite.GraphicTransTileDiamond;
import flixel.addons.transition.FlxTransitionableState;
import flixel.addons.transition.TransitionData;
import flixel.graphics.FlxGraphic;
import flixel.group.FlxGroup;
import flixel.input.gamepad.FlxGamepad;
import flixel.math.FlxPoint;
import flixel.math.FlxRect;
import flixel.util.FlxColor;
import flixel.util.FlxTimer;
import lime.app.Application;

class TitleState extends MusicBeatState {
	public static var initialized:Bool = false;

	var credGroup:FlxGroup;
	var ngSpr:FlxSprite;
	var darnSpr:FlxSprite;
	var titleText:FlxSprite;
	var logoBl:FlxSprite;

	var gfDance:FlxSprite;
	var danceLeft:Bool = false;

	var curWacky:Array<String> = [];
	var lastBeat:Int = 0;
	var skippedIntro:Bool = false;
	var transitioning:Bool = false;

	#if USE_SHADERS
	var swagShader:ColorSwap;
	#end

	#if web
	var video:Video;
	var netStream:NetStream;
	var overlay:Sprite;
	#end

	override public function create():Void {
		#if polymod
		polymod.Polymod.init({modRoot: 'mods', dirs: ['introMod'], framework: OPENFL});
		#end

		#if USE_SHADERS
		swagShader = new ColorSwap();
		#end

		curWacky = FlxG.random.getObject(getIntroTextShit());
		FlxG.sound.muteKeys = [ZERO];

		super.create();

		FlxG.save.bind('moddificil', 'neontflame');

		PreferencesMenu.initPrefs();
		PlayerSettings.init();
		Highscore.load();

		/* if (FlxG.save.data.weekUnlocked != null) { // QUICK PATCH OOPS!
			if (StoryMenuState.weekUnlocked.length < 4)
				StoryMenuState.weekUnlocked.insert(0, true);
			if (!StoryMenuState.weekUnlocked[0])
				StoryMenuState.weekUnlocked[0] = true;
		} */

		if (FlxG.save.data.seenVideo != null)
			VideoState.seenVideo = FlxG.save.data.seenVideo;

		new FlxTimer().start(1, function(tmr:FlxTimer) startIntro());

		#if discord_rpc
		DiscordClient.initialize();
		Application.current.onExit.add(function(exitCode) DiscordClient.shutdown());
		#end
	}

	#if web
	function client_onMetaData(e) {
		video.attachNetStream(netStream);
		video.width = video.videoWidth;
		video.height = video.videoHeight;
	}

	function netStream_onAsyncError(e)
		trace('Error loading video');

	function netConnection_onNetStatus(e) {
		if (e.info.code == 'NetStream.Play.Complete')
			startIntro();
		trace(e.toString());
	}

	function overlay_onMouseDown(e) {
		netStream.soundTransform.volume = 0.2;
		netStream.soundTransform.pan = -1;
		Lib.current.stage.removeChild(overlay);
	}
	#end

	function startIntro() {
		if (!initialized) {
			var diamond:FlxGraphic = FlxGraphic.fromClass(GraphicTransTileDiamond);
			diamond.persist = true;

			FlxTransitionableState.defaultTransIn = transIn = new TransitionData(FADE, FlxColor.BLACK, 1, new FlxPoint(0, -1),
				{asset: diamond, width: 32, height: 32}, new FlxRect(-200, -200, FlxG.width * 1.4, FlxG.height * 1.4));
			FlxTransitionableState.defaultTransOut = transOut = new TransitionData(FADE, FlxColor.BLACK, 0.7, new FlxPoint(0, 1),
				{asset: diamond, width: 32, height: 32}, new FlxRect(-200, -200, FlxG.width * 1.4, FlxG.height * 1.4));

			FlxG.sound.playMusic(Paths.music('freakyMenu'), 0);
			FlxG.sound.music.fadeIn(4, 0, 0.7);
			Conductor.changeBPM(93.571);
		}

		persistentUpdate = true;
		add(new FlxSprite().makeGraphic(FlxG.width, FlxG.height, FlxColor.BLACK));

		logoBl = new FlxSprite(-150, -100);
		logoBl.frames = Paths.getSparrowAtlas('ui/titleScreen/logoBumpin');
		logoBl.animation.addByPrefix('bump', 'logo bumpin', 24);
		logoBl.animation.play('bump');
		logoBl.updateHitbox();
		#if USE_SHADERS
		logoBl.shader = swagShader.shader;
		#end
		add(logoBl);

		gfDance = new FlxSprite(FlxG.width * 0.4, FlxG.height * 0.07);
		gfDance.frames = Paths.getSparrowAtlas('ui/titleScreen/gfDanceTitle');
		gfDance.animation.addByIndices('danceLeft', 'gfDance', [30, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14], '', 24, false);
		gfDance.animation.addByIndices('danceRight', 'gfDance', [15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29], '', 24, false);
		#if USE_SHADERS
		gfDance.shader = swagShader.shader;
		#end
		add(gfDance);

		titleText = new FlxSprite(100, FlxG.height * 0.8);
		titleText.frames = Paths.getSparrowAtlas('ui/titleScreen/titleEnter');
		titleText.animation.addByPrefix('idle', 'Press Enter to Begin', 24);
		titleText.animation.addByPrefix('press', 'ENTER PRESSED', 24);
		titleText.animation.play('idle');
		titleText.updateHitbox();
		add(titleText);

		credGroup = new FlxGroup();
		credGroup.add(new FlxSprite().makeGraphic(FlxG.width, FlxG.height, FlxColor.BLACK));
		add(credGroup);

		ngSpr = new FlxSprite(0, FlxG.height * 0.52).loadGraphic(Paths.image('ui/titleScreen/newgrounds_logo'));
		ngSpr.visible = false;
		ngSpr.setGraphicSize(Std.int(ngSpr.width * 0.8));
		ngSpr.updateHitbox();
		ngSpr.screenCenter(X);
		add(ngSpr);

		darnSpr = new FlxSprite(0, FlxG.height * 0.52).loadGraphic(Paths.image('ui/titleScreen/ah_shit'));
		darnSpr.visible = false;
		darnSpr.setGraphicSize(Std.int(ngSpr.width * 0.8));
		darnSpr.updateHitbox();
		darnSpr.screenCenter(X);
		add(darnSpr);
		
		FlxG.mouse.visible = false;

		if (initialized)
			skipIntro();
		else
			initialized = true;

		if (FlxG.sound.music != null)
			FlxG.sound.music.onComplete = function() FlxG.switchState(new VideoState());
	}

	function getIntroTextShit():Array<Array<String>> {
		var firstArray:Array<String> = Paths.getTextFileArray(Paths.txt('introText'));
		var swagGoodArray:Array<Array<String>> = [];

		for (i in firstArray)
			swagGoodArray.push(i.split('--'));
		return swagGoodArray;
	}

	override function update(elapsed:Float) {
		if (FlxG.sound.music != null)
			Conductor.songPosition = FlxG.sound.music.time;
		if (FlxG.keys.justPressed.FIVE || FlxG.keys.justPressed.EIGHT)
			FlxG.switchState(new CutsceneAnimTestState());

		var gamepad:FlxGamepad = FlxG.gamepads.lastActive;
		var pressedEnter:Bool = gamepad != null ? FlxG.keys.justPressed.ENTER || gamepad.justPressed.START : FlxG.keys.justPressed.ENTER;

		if (pressedEnter && !transitioning && skippedIntro) {
			if (FlxG.sound.music != null)
				FlxG.sound.music.onComplete = null;

			titleText.animation.play('press');
			FlxG.camera.flash(FlxColor.WHITE, 1);
			FlxG.sound.play(Paths.sound('confirmMenu'), 0.7);
			transitioning = true;
			FlxG.switchState(new MainMenuState());
		}

		if (pressedEnter && !skippedIntro && initialized)
			skipIntro();
		#if USE_SHADERS
		if (controls.UI_LEFT || controls.UI_RIGHT)
			swagShader.update(elapsed * (controls.UI_LEFT ? 0.1 : -0.1));
		#end

		super.update(elapsed);
	}

	function createCoolText(textArray:Array<String>) {
		for (i in 0...textArray.length) {
			var text:Alphabet = new Alphabet(0, 0, textArray[i], true, false);
			text.screenCenter(X);
			text.y += (i * 60) + 200;
			credGroup.add(text);
		}
	}

	function addMoreText(_text:String) {
		var text:Alphabet = new Alphabet(0, 0, _text, true, false);
		text.screenCenter(X);
		text.y += ((credGroup.length - 1) * 60) + 200;
		credGroup.add(text);
	}

	function deleteCoolText() {
		while (credGroup.members.length > 1)
			credGroup.remove(credGroup.members[1], true);
	}

	override function beatHit() {
		super.beatHit();

		if (logoBl != null && gfDance != null) {
			logoBl.animation.play('bump');
			danceLeft = !danceLeft;
			gfDance.animation.play(danceLeft ? 'danceRight' : 'danceLeft');
		}

		if (curBeat > lastBeat && credGroup != null) {
			for (i in lastBeat...curBeat) {
				switch (i + 1) {
					case 1:
						createCoolText(['saca so']);
					// credTextShit.visible = true;
					case 2:
						addMoreText('neontflame');
						addMoreText('junto de');
					case 3:
						addMoreText('dex dousky');
					case 4:
						addMoreText('apresentam');
					// credTextShit.text += '\npresent...';
					// credTextShit.addText();
					case 7:
						deleteCoolText();
					// credTextShit.visible = false;
					// credTextShit.text = 'In association \nwith';
					// credTextShit.screenCenter();
					case 9:
						createCoolText(['feito por uns']);
					case 10:
						addMoreText('doido do');
					case 11:
						addMoreText('edc');
					case 13:
						ngSpr.visible = true;
					// credTextShit.text += '\nNewgrounds';
					case 15:
						deleteCoolText();
						ngSpr.visible = false;
					// credTextShit.visible = false;

					// credTextShit.text = 'Shoutouts Tom Fulp';
					// credTextShit.screenCenter();
					case 17:
						createCoolText([curWacky[0]]);
					// credTextShit.visible = true;
					case 19:
						addMoreText(curWacky[1]);
					// credTextShit.text += '\nlmao';
					case 24:
						deleteCoolText();
					// credTextShit.visible = false;
					// credTextShit.text = "Friday";
					// credTextShit.screenCenter();
					case 25:
						createCoolText(['e laiala']);
					case 27:
						addMoreText('placeholder');
					case 29:
						darnSpr.visible = true;
					case 31:
						darnSpr.visible = false;
						deleteCoolText();
					case 33:
						createCoolText(['Friday']);
					// credTextShit.visible = true;
					case 35:
						addMoreText('Night');
					// credTextShit.text += '\nNight';
					case 37:
						addMoreText('Funkin'); // credTextShit.text += '\nFunkin';
					case 38:
						addMoreText('Mod');
					case 39:
						addMoreText('Dificil');

					case 40:
						skipIntro();
				}
			}
		}

		lastBeat = curBeat;
	}

	function skipIntro():Void {
		if (!skippedIntro) {
			FlxG.camera.flash(FlxColor.WHITE, 4);
			skippedIntro = true;
			remove(ngSpr, true);
			remove(credGroup, true);
		}
	}
}
