package;

#if USE_SHADERS
import shaders.BuildingShaders;
import shaders.ColorSwap;
#end
import animate.FlxAnimate;
import flixel.FlxCamera;
import flixel.FlxG;
import flixel.FlxObject;
import flixel.FlxSprite;
import flixel.FlxBasic;
import flixel.FlxState;
import flixel.addons.effects.chainable.FlxWaveEffect;
import flixel.group.FlxGroup.FlxTypedGroup;
import flixel.group.FlxSpriteGroup;
import flixel.math.FlxPoint;
import flixel.sound.FlxSound;
import flixel.text.FlxText;
import flixel.tweens.FlxTween;
import PlayState;
import crowplexus.iris.Iris;
import crowplexus.iris.IrisConfig;
import openfl.utils.Assets as OpenFlAssets;

import bg.*;
import backend.IrisHandler;

using StringTools;

/**
	This is the stage class. It sets up everything you need for stages in a more organised and clean manner than the
	base game. It's not too bad, just very crowded. I'll be adding stages as a separate
	thing to the weeks, making them not hardcoded to the songs.
**/
class Stage extends FlxTypedGroup<FlxBasic> {
	public var stageScript:IrisHandler;

	public var curStage:String;

	var daPixelZoom = PlayState.daPixelZoom;

	var gfVersion:String = 'gf';

	public function new(curStage) {
		super();
		
		this.curStage = curStage;

		// this is because I want to avoid editing the fnf chart type
		// custom stage stuffs will come with forever charts
		switch (CoolUtil.spaceToDash(PlayState.SONG.song.toLowerCase())) {
			case 'mod-dificil':
				curStage = 'dificil';
				PlayState.curStage = curStage;
			default:
				curStage = 'stage';
		}
		
		stageScript = new IrisHandler();
		var file:String = Paths.script('stages/' + PlayState.curStage);
		trace(file);

		trace(CoolUtil.fileExists(file));
		if (CoolUtil.fileExists(file))
		{
			trace("Stage: " + file);
			stageScript.addByPath(file);
			stageScript.setup();
			stageScript.set('stage', this);
		}
	}

	// todo: move these giant switch statements and their variables to individual scripts
	// decluttering my behated

	public function createStageBack() {
		var boyfriend:Boyfriend = PlayState.instance.boyfriend;
		var gf:Character = PlayState.instance.gf;
		var dad:Character = PlayState.instance.dad;
		stageScript.set('bf', boyfriend);
		stageScript.set('gf', gf);
		stageScript.set('dad', dad);
		
		switch (PlayState.curStage) {
			case 'stage':
				PlayState.defaultCamZoom = 0.9;
				curStage = 'stage';
				var bg:FlxSprite = new FlxSprite(-600, -200).loadGraphic(Paths.image('backgrounds/' + curStage + '/stageback'));
				bg.scrollFactor.set(0.9, 0.9);
				bg.active = false;

				// add to the final array
				add(bg);

				var stageFront:FlxSprite = new FlxSprite(-650, 600).loadGraphic(Paths.image('backgrounds/' + curStage + '/stagefront'));
				stageFront.setGraphicSize(Std.int(stageFront.width * 1.1));
				stageFront.updateHitbox();
				stageFront.scrollFactor.set(0.9, 0.9);
				stageFront.active = false;

				// add to the final array
				add(stageFront);

				var stageCurtains:FlxSprite = new FlxSprite(-500, -300).loadGraphic(Paths.image('backgrounds/' + curStage + '/stagecurtains'));
				stageCurtains.setGraphicSize(Std.int(stageCurtains.width * 0.9));
				stageCurtains.updateHitbox();
				stageCurtains.scrollFactor.set(1.3, 1.3);
				stageCurtains.active = false;

				// add to the final array
				add(stageCurtains);
		}
		
		stageScript.call('createStageBack');
	}
	
	public function createStageMiddle() {
		stageScript.call('createStageMiddle');
	}
	
	public function createStageFront() {
		stageScript.call('createStageFront');
	}
	
	// return the girlfriend's type
	public function returnGFtype(curStage) {
		switch (curStage) {
			case 'limo':
				gfVersion = 'gf-car';
			case 'school':
				gfVersion = 'gf-pixel';
			case 'schoolEvil':
				gfVersion = 'gf-pixel';
			case 'tank':
				gfVersion = 'gf-tankmen';
		}

		if (PlayState.SONG.song.toLowerCase() == 'stress')
			gfVersion = 'pico-speaker';

		return gfVersion;
	}

	// get the dad's position
	public function dadPosition(curStage, dad:Character, gf:Character, camPos:FlxPoint, songPlayer2):Void {
		switch (songPlayer2) {
			case 'gf':
				dad.setPosition(gf.x, gf.y);
				gf.visible = false;
		}
	}

	public function stageUpdate(curBeat:Int, boyfriend:Boyfriend, gf:Character, dad:Character) {
		stageScript.call('beatHit', [curBeat]);
	}

	public function stageUpdateConstant(elapsed:Float, boyfriend:Boyfriend, gf:Character, dad:Character) {
		stageScript.call('update', [elapsed]);
	}

	override function add(Object:FlxBasic):FlxBasic {
		stageScript.set('add', this);
		PlayState.instance.add(Object);
		return super.add(Object);
	}
}
