package;

#if discord_rpc
import Discord.DiscordClient;
#end
import flash.text.TextField;
import flixel.FlxG;
import flixel.FlxSprite;
import flixel.addons.display.FlxGridOverlay;
import flixel.group.FlxGroup.FlxTypedGroup;
import flixel.math.FlxMath;
import flixel.text.FlxText;
import flixel.util.FlxColor;
import lime.utils.Assets;

class CreditsState extends MusicBeatState {
	var selector:FlxText;

	static var curSelected:Int = 0;
	static var curDifficulty:Int = 1;

	var bg:FlxSprite;
	var scoreBG:FlxSprite;
	var scoreText:FlxText;

	private var grpSongs:FlxTypedGroup<Alphabet>;
	private var coolColors = [
		0xFF33CC66,
		0xFFCC6600,
		0xFFFFB237,
		0xFF66CCFF,
		0xFFFF6600,
		0xFFFF9900,
		0xFF5F2F8F
	];

	private var curPlaying:Bool = false;

	private var iconArray:Array<HealthIcon> = [];
	var creditados:Array<String> = ['neontflame', 
									'dexdousky', 
									'el_passo', 
									'sketcher', 
									'sushi', 
									'fupicat', 
									'dafver'];
	var creditadosFezOQ:Array<String> = ['Código, animação, arte, música, puxou cordas', 
										'Música', 
										'Puxou cordas', 
										'Puxando cordas', 
										'Puxando cordas', 
										'Inspiração, música', 
										'O cara do dinheiro, tava na call q eu desenhei o juaos'];

	override function create() {
		
		/* 
			if (FlxG.sound.music != null)
			{
				if (!FlxG.sound.music.playing)
					FlxG.sound.playMusic(Paths.music('freakyMenu'));
			}
		 */

		#if dicord_rpc
		// Updating Discord Rich Presence
		DiscordClient.changePresence('In the Menus', null);
		#end

		if (!FlxG.sound.music.playing) {
			FlxG.sound.playMusic(Paths.music('freakyMenu'));
		}


		// LOAD MUSIC

		// LOAD CHARACTERS

		bg = new FlxSprite().loadGraphic(Paths.image('ui/menus/menuBG'));
		add(bg);

		grpSongs = new FlxTypedGroup<Alphabet>();
		add(grpSongs);

		for (i in 0...creditados.length) {
			var songText:Alphabet = new Alphabet(0, (70 * i) + 30, creditados[i], true, false);
			songText.isMenuItem = true;
			songText.targetY = i;
			grpSongs.add(songText);

			var icon:HealthIcon = new HealthIcon('creditos/' + creditados[i]);
			icon.sprTracker = songText;
			
			/* if (creditados[i] == 'neontflame') {
				icon.animation.curAnim.curFrame = FlxG.random.int(0, 1);
			} */

			// using a FlxGroup is too much fuss!
			iconArray.push(icon);
			add(icon);
		}

		scoreText = new FlxText(FlxG.width * 0.7, 5, 0, '', 32);
		// scoreText.autoSize = false;
		scoreText.setFormat(Paths.font('vcr.ttf'), 32, FlxColor.WHITE, RIGHT);
		// scoreText.alignment = RIGHT;

		scoreBG = new FlxSprite(scoreText.x - 6, 0).makeGraphic(1, 66, 0xFF000000);
		scoreBG.antialiasing = false;
		scoreBG.alpha = 0.6;
		add(scoreBG);

		add(scoreText);

		changeSelection();

		// FlxG.sound.playMusic(Paths.music('title'), 0);
		// FlxG.sound.music.fadeIn(2, 0, 0.8);
		selector = new FlxText();

		selector.size = 40;
		selector.text = '>';
		// add(selector);

		var swag:Alphabet = new Alphabet(1, 0, 'swag');

		super.create();
	}

	override function update(elapsed:Float):Void {
		super.update(elapsed);

		if (FlxG.sound.music != null && FlxG.sound.music.volume < 0.7) {
			FlxG.sound.music.volume += 0.5 * FlxG.elapsed;
		}

		bg.color = FlxColor.interpolate(bg.color, coolColors[curSelected], MathFunctions.fixedLerpValue(0.045));

		scoreText.text = creditadosFezOQ[curSelected];
		positionHighscore();

		var left:Bool = controls.UI_LEFT_P;
		var right:Bool = controls.UI_RIGHT_P;
		var up:Bool = controls.UI_UP_P;
		var down:Bool = controls.UI_DOWN_P;
		var accept:Bool = controls.ACCEPT;
		var back:Bool = controls.BACK;

		if (up)
			changeSelection(-1);
		if (down)
			changeSelection(1);
		if (FlxG.mouse.wheel != 0)
			changeSelection(-Math.round(FlxG.mouse.wheel));

		if (back) {
			FlxG.sound.play(Paths.sound('cancelMenu'));
			FlxG.switchState(new MainMenuState());
		}
		
		if (accept) {
			FlxG.sound.play(Paths.sound('confirmMenu'));
			#if linux
			Sys.command('/usr/bin/xdg-open', [
				'https://especulamente.com.br/usuarios/' + creditados[curSelected],
				'&'
			]);
			#else
			FlxG.openURL('https://especulamente.com.br/usuarios/' + creditados[curSelected]);
			#end
		}
	}

	function changeSelection(change:Int = 0):Void {
		FlxG.sound.play(Paths.sound('scrollMenu'), 0.4);
		curSelected = FlxMath.wrap(curSelected + change, 0, creditados.length - 1);

		for (i in 0...iconArray.length) {
			iconArray[i].alpha = 0.6;
		}

		iconArray[curSelected].alpha = 1;

		for (i in 0...grpSongs.length) {
			var item:Alphabet = grpSongs.members[i];
			item.targetY = i - curSelected;

			if (item.targetY == 0)
				item.alpha = 1.0;
			else
				item.alpha = 0.6;
		}
	}

	function positionHighscore():Void {
		scoreText.x = FlxG.width - scoreText.width - 6;
		scoreBG.scale.x = FlxG.width - scoreText.x + 6;
		scoreBG.x = FlxG.width - scoreBG.scale.x / 2;
	}
}